#ifndef LPC5400X_FIRMWARE_UPDATE_H
#define LPC5400X_FIRMWARE_UPDATE_H

#include <linux/types.h>

enum _SL_IFSEL_T {
    SL_AUTO = 0, /*!< Auto-detect 2nd boot loader host interface */
    SL_I2C0, /*!< I2C0 used for secondary loader host interface */
    SL_I2C1, /*!< I2C1 used for secondary loader host interface */
    SL_I2C2, /*!< I2C2 used for secondary loader host interface */
    SL_SPI0, /*!< SPI0 used for secondary loader host interface */
    SL_SPI1 /*!< SPI1 used for secondary loader host interface */
};

bool lpc5400x_updateFirmware(struct i2c_client *client, char *fw_name);
bool lpc5400x_probebus(struct i2c_client *client, enum _SL_IFSEL_T busport, int irq_gpio);

#endif /* LPC5400X_FIRMWARE_UPDATE_H */
